#include "mode1/erdiagram/Attribute.h"
#include "mode1/erdiagram/AttributesRect.h"
#include "mode1/erdiagram/Table.h"
#include "mode1/erdiagram/Canvas.h"
#include "mode1/DrawERDlg.h"

Attribute::Attribute(QRectF rect, int count, QString text, QGraphicsItem * parent) : QGraphicsTextItem(text, parent)
{
	this->setPos(rect.x()+5, rect.y()+(16*count)+2);
	this->rect = QRectF(rect.x()+5, rect.y()+(16*count)+2, rect.width(), rect.height());
	Canvas* canvas = DrawERDlg::getInstance()->GetCanvas();
	connect(this, SIGNAL(lostFocus3(Attribute *)), canvas, SLOT(editorLostFocus3(Attribute *)));
}

Attribute::~Attribute()
{
}

void Attribute::keyPressEvent ( QKeyEvent * event )
{
	if( event->key() == Qt::Key_Enter || event->key() == Qt::Key_Return ){
		this->setSelected(false);
		this->clearFocus();		
	}

	else if( event->modifiers() == Qt::ControlModifier && event->key() == Qt::Key_Equal){
		((AttributesRect*)(this->parentItem()))->InsertAttribute();
	}
	else if( event->modifiers() == Qt::ControlModifier && event->key() == Qt::Key_Minus){
		AttributesRect* attributesRect = (AttributesRect*)(this->parentItem());
		Table* table = (Table*)(attributesRect->parentItem());
		
		if( attributesRect->GetAttributes().count() > 1 ){
			attributesRect->DeleteAttribute(this);
		}

		table->ReSize();
	}
	else{
		QGraphicsTextItem::keyPressEvent(event);
	}
}

void Attribute::mousePressEvent ( QGraphicsSceneMouseEvent * event )
{
	this->scene()->clearSelection();
	setTextInteractionFlags(Qt::TextEditorInteraction);
    QGraphicsSceneMouseEvent *mouseEvent =
        new QGraphicsSceneMouseEvent(QEvent::GraphicsSceneMousePress);
    mouseEvent->setAccepted(true);
    mouseEvent->setPos(event->pos());
    mouseEvent->setScenePos(event->scenePos());
    mouseEvent->setScreenPos(event->screenPos());
    mouseEvent->setButtonDownPos(Qt::LeftButton,
        event->buttonDownPos(Qt::LeftButton));
    mouseEvent->setButtonDownScreenPos(Qt::LeftButton,
        event->buttonDownScreenPos(Qt::LeftButton));
    mouseEvent->setButtonDownScenePos(Qt::LeftButton,
        event->buttonDownScenePos(Qt::LeftButton));
    mouseEvent->setWidget(event->widget());
	
    QGraphicsTextItem::mousePressEvent(mouseEvent);
	
    delete mouseEvent;
}

void Attribute::SetPosition(int state)
{
	if( state == 1 ){
		this->setPos(this->pos().x(), this->pos().y()+16);
	}
	else if( state == 0 ){
		this->setPos(this->pos().x(), this->pos().y()-16);
	}

	//this->setPos(this->rect.x(), this->rect.y());
}

void Attribute::focusOutEvent(QFocusEvent *event)
{
    this->setTextInteractionFlags(Qt::NoTextInteraction);
	
	Table* table = (Table*)(((AttributesRect*)(this->parentItem()))->parentItem());
	
	QRectF tableRect = table->boundingRect();
	QRectF textRect = this->boundingRect();
	
	if( tableRect.width() < this->boundingRect().width()+14 ){
		table->ReSize();
	}
	
	emit lostFocus3(this);
	
	QGraphicsTextItem::focusOutEvent(event);
}
